import _extends from "@babel/runtime/helpers/esm/extends";
import * as React from 'react';
import { styled } from '@mui/system';
import composeClasses from '@mui/utils/composeClasses';
import { gridHasBottomFillerSelector, gridHasScrollXSelector, gridHasScrollYSelector } from "../../hooks/features/dimensions/gridDimensionsSelectors.js";
import { GridScrollArea } from "../GridScrollArea.js";
import { useGridRootProps } from "../../hooks/utils/useGridRootProps.js";
import { useGridApiContext } from "../../hooks/utils/useGridApiContext.js";
import { useGridSelector } from "../../hooks/utils/useGridSelector.js";
import { getDataGridUtilityClass } from "../../constants/gridClasses.js";
import { useGridVirtualScroller } from "../../hooks/features/virtualization/useGridVirtualScroller.js";
import { useGridOverlays } from "../../hooks/features/overlays/useGridOverlays.js";
import { GridHeaders } from "../GridHeaders.js";
import { GridMainContainer as Container } from "./GridMainContainer.js";
import { GridTopContainer as TopContainer } from "./GridTopContainer.js";
import { GridVirtualScrollerContent as Content } from "./GridVirtualScrollerContent.js";
import { GridVirtualScrollerFiller as SpaceFiller } from "./GridVirtualScrollerFiller.js";
import { GridVirtualScrollerRenderZone as RenderZone } from "./GridVirtualScrollerRenderZone.js";
import { GridVirtualScrollbar as Scrollbar } from "./GridVirtualScrollbar.js";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
const useUtilityClasses = ownerState => {
  const {
    classes,
    hasScrollX,
    hasPinnedRight,
    loadingOverlayVariant,
    overlayType
  } = ownerState;
  const hideContent = loadingOverlayVariant === 'skeleton' || overlayType === 'noColumnsOverlay';
  const slots = {
    root: ['main', hasPinnedRight && 'main--hasPinnedRight', hideContent && 'main--hiddenContent'],
    scroller: ['virtualScroller', hasScrollX && 'virtualScroller--hasScrollX']
  };
  return composeClasses(slots, getDataGridUtilityClass, classes);
};
const Scroller = styled('div', {
  name: 'MuiDataGrid',
  slot: 'VirtualScroller',
  overridesResolver: (props, styles) => {
    const {
      ownerState
    } = props;
    return [styles.virtualScroller, ownerState.hasScrollX && styles['virtualScroller--hasScrollX']];
  }
})({
  position: 'relative',
  height: '100%',
  flexGrow: 1,
  overflow: 'scroll',
  scrollbarWidth: 'none' /* Firefox */,
  display: 'flex',
  flexDirection: 'column',
  '&::-webkit-scrollbar': {
    display: 'none' /* Safari and Chrome */
  },
  '@media print': {
    overflow: 'hidden'
  },
  // See https://github.com/mui/mui-x/issues/10547
  zIndex: 0
});
const hasPinnedRightSelector = apiRef => apiRef.current.state.dimensions.rightPinnedWidth > 0;
function GridVirtualScroller(props) {
  const apiRef = useGridApiContext();
  const rootProps = useGridRootProps();
  const hasScrollY = useGridSelector(apiRef, gridHasScrollYSelector);
  const hasScrollX = useGridSelector(apiRef, gridHasScrollXSelector);
  const hasPinnedRight = useGridSelector(apiRef, hasPinnedRightSelector);
  const hasBottomFiller = useGridSelector(apiRef, gridHasBottomFillerSelector);
  const {
    getOverlay,
    overlaysProps
  } = useGridOverlays();
  const ownerState = _extends({
    classes: rootProps.classes,
    hasScrollX,
    hasPinnedRight
  }, overlaysProps);
  const classes = useUtilityClasses(ownerState);
  const virtualScroller = useGridVirtualScroller();
  const {
    getContainerProps,
    getScrollerProps,
    getContentProps,
    getRenderZoneProps,
    getScrollbarVerticalProps,
    getScrollbarHorizontalProps,
    getRows,
    getScrollAreaProps
  } = virtualScroller;
  const rows = getRows();
  return /*#__PURE__*/_jsxs(Container, _extends({
    className: classes.root
  }, getContainerProps(), {
    ownerState: ownerState,
    children: [/*#__PURE__*/_jsx(GridScrollArea, _extends({
      scrollDirection: "left"
    }, getScrollAreaProps())), /*#__PURE__*/_jsx(GridScrollArea, _extends({
      scrollDirection: "right"
    }, getScrollAreaProps())), /*#__PURE__*/_jsx(GridScrollArea, _extends({
      scrollDirection: "up"
    }, getScrollAreaProps())), /*#__PURE__*/_jsx(GridScrollArea, _extends({
      scrollDirection: "down"
    }, getScrollAreaProps())), /*#__PURE__*/_jsxs(Scroller, _extends({
      className: classes.scroller
    }, getScrollerProps(), {
      ownerState: ownerState,
      children: [/*#__PURE__*/_jsxs(TopContainer, {
        children: [!rootProps.listView && /*#__PURE__*/_jsx(GridHeaders, {}), /*#__PURE__*/_jsx(rootProps.slots.pinnedRows, {
          position: "top",
          virtualScroller: virtualScroller
        })]
      }), getOverlay(), /*#__PURE__*/_jsx(Content, _extends({}, getContentProps(), {
        children: /*#__PURE__*/_jsxs(RenderZone, _extends({}, getRenderZoneProps(), {
          children: [rows, /*#__PURE__*/_jsx(rootProps.slots.detailPanels, {
            virtualScroller: virtualScroller
          })]
        }))
      })), hasBottomFiller && /*#__PURE__*/_jsx(SpaceFiller, {
        rowsLength: rows.length
      }), /*#__PURE__*/_jsx(rootProps.slots.bottomContainer, {
        children: /*#__PURE__*/_jsx(rootProps.slots.pinnedRows, {
          position: "bottom",
          virtualScroller: virtualScroller
        })
      })]
    })), hasScrollX && !rootProps.listView && /*#__PURE__*/_jsx(Scrollbar, _extends({
      position: "horizontal"
    }, getScrollbarHorizontalProps())), hasScrollY && /*#__PURE__*/_jsx(Scrollbar, _extends({
      position: "vertical"
    }, getScrollbarVerticalProps())), props.children]
  }));
}
export { GridVirtualScroller };